-- ScreenOptionsFilter icon is a bit different.
local iIndex = Var("GameCommand"):GetIndex();
local sName = Var("GameCommand"):GetName();
local pn = sName == "Player1" and PLAYER_1 or PLAYER_2;
local pName = pname(pn);

local filterColor = nil;
if GetUserPref("FilterColor"..pName) == nil then
	filterColor = color("0,0,0,0.5");
	SetUserPref("FilterColor"..pName, "#".. ColorToHex(filterColor));
else
	filterColor = color(GetUserPref("FilterColor"..pName));
end;

local t = Def.ActorFrame{};

t[#t+1] = Def.ActorFrame{
	Name="Item"..iIndex;

	Def.Quad{
		InitCommand=cmd(zoomto,256,SCREEN_HEIGHT;diffuse,filterColor);
	};

	AutoText("frutiger")..{
		Text="Player ".. iIndex+1;
		InitCommand=cmd(shadowlength,1;diffuse,color("#FFFFFF");NoStroke);
		OnCommand=cmd(y,(SCREEN_CENTER_Y*0.85)-48);
		GainFocusCommand=cmd(accelerate,0.15;zoom,1;diffuse,color("1,1,1,1"));
		LoseFocusCommand=cmd(stoptweening;decelerate,0.15;zoom,0.8;diffuse,color("0.6,0.6,0.6,0.9"));
	};

	-- repurpose as color value
	AutoText("frutiger")..{
		Name="FilterColor"..iIndex;
		InitCommand=cmd(shadowlength,1;zoom,0.6;diffuse,color("#FFFFFF");NoStroke);
		BeginCommand=function(self)
			local hex = ColorToHex( filterColor );
			self:settext( "#"..hex );
		end;
		OnCommand=cmd(y,SCREEN_CENTER_Y*0.8);
	};
};

return t;